<?php
session_start();
require_once 'db_connect.php';

if (!isset($_SESSION['admin_logged_in']) || $_SESSION['admin_logged_in'] !== true) {
    header("Location: login.php");
    exit;
}

$id = isset($_GET['id']) ? intval($_GET['id']) : 0;
$username = "";
$password = "";
$full_name = "";
$pin = "";
$role = "staff";
$branch_id = 1;
$title = "Tambah User Baru";
$error = "";

// Ambil data cabang untuk dropdown
$branches = $conn->query("SELECT * FROM branches ORDER BY name ASC");

if ($id > 0) {
    $title = "Edit User";
    $stmt = $conn->prepare("SELECT * FROM users WHERE id = ?");
    $stmt->bind_param("i", $id);
    $stmt->execute();
    $result = $stmt->get_result();
    if ($result->num_rows > 0) {
        $row = $result->fetch_assoc();
        $username = $row['username'];
        $full_name = $row['full_name'];
        $pin = $row['pin'];
        $role = $row['role'];
        $branch_id = $row['branch_id'];
        // Password tidak ditampilkan demi keamanan
    }
}

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $username = $_POST['username'];
    $full_name = $_POST['full_name'];
    $pin = $_POST['pin'];
    $role = $_POST['role'];
    $branch_id = intval($_POST['branch_id']);
    $new_password = $_POST['password'];

    // Validasi sederhana
    if (!empty($username) && !empty($full_name) && !empty($pin)) {
        
        if ($id > 0) {
            // Update User
            if (!empty($new_password)) {
                // Jika password diisi, update password juga
                $stmt = $conn->prepare("UPDATE users SET username = ?, password = ?, full_name = ?, pin = ?, role = ?, branch_id = ? WHERE id = ?");
                $stmt->bind_param("ssssssi", $username, $new_password, $full_name, $pin, $role, $branch_id, $id);
            } else {
                // Jika password kosong, jangan ubah password lama
                $stmt = $conn->prepare("UPDATE users SET username = ?, full_name = ?, pin = ?, role = ?, branch_id = ? WHERE id = ?");
                $stmt->bind_param("sssssi", $username, $full_name, $pin, $role, $branch_id, $id);
            }
        } else {
            // Insert User Baru
            if (!empty($new_password)) {
                $stmt = $conn->prepare("INSERT INTO users (username, password, full_name, pin, role, branch_id) VALUES (?, ?, ?, ?, ?, ?)");
                $stmt->bind_param("sssssi", $username, $new_password, $full_name, $pin, $role, $branch_id);
            } else {
                $error = "Password wajib diisi untuk user baru.";
            }
        }

        if (!$error) {
            if ($stmt->execute()) {
                header("Location: users.php");
                exit;
            } else {
                $error = "Gagal menyimpan (Username atau PIN mungkin sudah digunakan).";
            }
        }
    } else {
        $error = "Semua kolom wajib diisi.";
    }
}
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $title; ?></title>
    <style>
        body { margin: 0; font-family: sans-serif; display: flex; height: 100vh; background-color: #f0f2f5; }
        .sidebar { width: 250px; background-color: #343a40; color: white; display: flex; flex-direction: column; }
        .sidebar-header { padding: 20px; text-align: center; border-bottom: 1px solid #4b545c; font-size: 20px; font-weight: bold; }
        .menu { list-style: none; padding: 0; margin: 0; }
        .menu li { border-bottom: 1px solid #4b545c; }
        .menu a { display: block; padding: 15px 20px; color: #c2c7d0; text-decoration: none; transition: 0.3s; }
        .menu a:hover, .menu a.active { background-color: #495057; color: white; }
        .content { flex: 1; padding: 20px; overflow-y: auto; }
        .header { background: white; padding: 15px; border-radius: 5px; box-shadow: 0 2px 5px rgba(0,0,0,0.1); display: flex; justify-content: space-between; align-items: center; margin-bottom: 20px; }
        .card { background: white; padding: 20px; border-radius: 5px; box-shadow: 0 2px 5px rgba(0,0,0,0.1); max-width: 600px; margin: 0 auto; }
        .form-group { margin-bottom: 15px; }
        .form-group label { display: block; margin-bottom: 5px; font-weight: bold; }
        .form-group input, .form-group select { width: 100%; padding: 10px; border: 1px solid #ddd; border-radius: 4px; box-sizing: border-box; }
        .btn { padding: 10px 15px; border: none; border-radius: 4px; cursor: pointer; text-decoration: none; font-size: 14px; display: inline-block; }
        .btn-primary { background-color: #007bff; color: white; }
        .btn-secondary { background-color: #6c757d; color: white; }
        .btn-logout { background-color: #dc3545; color: white; }
        .note { font-size: 12px; color: #666; margin-top: 5px; display: block; }
    </style>
</head>
<body>

    <div class="sidebar">
        <div class="sidebar-header">Admin Panel</div>
        <ul class="menu">
            <li><a href="index.php">Dashboard</a></li>
            <li><a href="branches.php">Outlet</a></li>
            <li><a href="users.php" class="active">Karyawan</a></li>
            <li><a href="products.php">Produk</a></li>
            <li><a href="stocks.php">Stok</a></li>
            <li><a href="transactions.php">Laporan</a></li>
        </ul>
    </div>

    <div class="content">
        <div class="header">
            <h2><?php echo $title; ?></h2>
            <a href="logout.php" class="btn btn-logout">Keluar</a>
        </div>
        
        <div class="card">
            <?php if($error): ?>
                <p style="color: red; text-align: center;"><?php echo $error; ?></p>
            <?php endif; ?>
            
            <form method="POST">
                <div class="form-group">
                    <label>Username (Login)</label>
                    <input type="text" name="username" value="<?php echo htmlspecialchars($username); ?>" required>
                </div>

                <div class="form-group">
                    <label>Password</label>
                    <input type="password" name="password" placeholder="<?php echo ($id > 0) ? 'Kosongkan jika tidak ingin mengubah password' : ''; ?>">
                </div>

                <div class="form-group">
                    <label>Nama Lengkap</label>
                    <input type="text" name="full_name" value="<?php echo htmlspecialchars($full_name); ?>" required>
                </div>

                <div class="form-group">
                    <label>PIN (Untuk Login POS)</label>
                    <input type="number" name="pin" value="<?php echo htmlspecialchars($pin); ?>" required>
                </div>

                <div class="form-group">
                    <label>Role</label>
                    <select name="role">
                        <option value="staff" <?php echo $role == 'staff' ? 'selected' : ''; ?>>Staff / Kasir</option>
                        <option value="admin" <?php echo $role == 'admin' ? 'selected' : ''; ?>>Admin</option>
                    </select>
                </div>

                <div class="form-group">
                    <label>Penempatan Outlet</label>
                    <select name="branch_id">
                        <?php while($b = $branches->fetch_assoc()): ?>
                            <option value="<?php echo $b['id']; ?>" <?php echo $branch_id == $b['id'] ? 'selected' : ''; ?>>
                                <?php echo htmlspecialchars($b['name']); ?>
                            </option>
                        <?php endwhile; ?>
                    </select>
                </div>

                <div style="margin-top: 20px; display: flex; gap: 10px;">
                    <button type="submit" class="btn btn-primary">Simpan</button>
                    <a href="users.php" class="btn btn-secondary">Batal</a>
                </div>
            </form>
        </div>
    </div>

</body>
</html>