<?php
session_start();
require_once 'db_connect.php';

if (!isset($_SESSION['admin_logged_in']) || $_SESSION['admin_logged_in'] !== true) {
    header("Location: login.php");
    exit;
}

$id = isset($_GET['id']) ? intval($_GET['id']) : 0;
$name = "";
$price = "";
$category = "umum";
$is_active = 1;
$title = "Tambah Produk Baru";
$error = "";

if ($id > 0) {
    $title = "Edit Produk";
    $stmt = $conn->prepare("SELECT * FROM products WHERE id = ?");
    $stmt->bind_param("i", $id);
    $stmt->execute();
    $result = $stmt->get_result();
    if ($result->num_rows > 0) {
        $row = $result->fetch_assoc();
        $name = $row['name'];
        $price = $row['price'];
        $category = $row['category'];
        $is_active = $row['is_active'];
    }
}

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $name = $_POST['name'];
    $price = $_POST['price'];
    $category = $_POST['category'];
    $is_active = intval($_POST['is_active']);

    if ($id > 0) {
        $stmt = $conn->prepare("UPDATE products SET name = ?, price = ?, category = ?, is_active = ? WHERE id = ?");
        $stmt->bind_param("sdsii", $name, $price, $category, $is_active, $id);
    } else {
        $stmt = $conn->prepare("INSERT INTO products (name, price, category, is_active) VALUES (?, ?, ?, ?)");
        $stmt->bind_param("sdsi", $name, $price, $category, $is_active);
    }

    if ($stmt->execute()) {
        header("Location: products.php");
        exit;
    } else {
        $error = "Terjadi kesalahan saat menyimpan data.";
    }
}
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $title; ?></title>
    <style>
        body { margin: 0; font-family: sans-serif; display: flex; height: 100vh; background-color: #f0f2f5; }
        .sidebar { width: 250px; background-color: #343a40; color: white; display: flex; flex-direction: column; }
        .sidebar-header { padding: 20px; text-align: center; border-bottom: 1px solid #4b545c; font-size: 20px; font-weight: bold; }
        .menu { list-style: none; padding: 0; margin: 0; }
        .menu li { border-bottom: 1px solid #4b545c; }
        .menu a { display: block; padding: 15px 20px; color: #c2c7d0; text-decoration: none; transition: 0.3s; }
        .menu a:hover, .menu a.active { background-color: #495057; color: white; }
        .content { flex: 1; padding: 20px; overflow-y: auto; }
        .header { background: white; padding: 15px; border-radius: 5px; box-shadow: 0 2px 5px rgba(0,0,0,0.1); display: flex; justify-content: space-between; align-items: center; margin-bottom: 20px; }
        .card { background: white; padding: 20px; border-radius: 5px; box-shadow: 0 2px 5px rgba(0,0,0,0.1); max-width: 600px; margin: 0 auto; }
        .form-group { margin-bottom: 15px; }
        .form-group label { display: block; margin-bottom: 5px; font-weight: bold; }
        .form-group input, .form-group select { width: 100%; padding: 10px; border: 1px solid #ddd; border-radius: 4px; box-sizing: border-box; }
        .btn { padding: 10px 15px; border: none; border-radius: 4px; cursor: pointer; text-decoration: none; font-size: 14px; display: inline-block; }
        .btn-primary { background-color: #007bff; color: white; }
        .btn-secondary { background-color: #6c757d; color: white; }
        .btn-logout { background-color: #dc3545; color: white; }
    </style>
</head>
<body>

    <div class="sidebar">
        <div class="sidebar-header">Admin Panel</div>
        <ul class="menu">
            <li><a href="index.php">Dashboard</a></li>
            <li><a href="branches.php">Outlet</a></li>
            <li><a href="users.php">Karyawan</a></li>
            <li><a href="products.php" class="active">Produk</a></li>
            <li><a href="stocks.php">Stok</a></li>
            <li><a href="transactions.php">Laporan</a></li>
        </ul>
    </div>

    <div class="content">
        <div class="header">
            <h2><?php echo $title; ?></h2>
            <a href="logout.php" class="btn btn-logout">Keluar</a>
        </div>
        
        <div class="card">
            <?php if($error): ?>
                <p style="color: red; text-align: center;"><?php echo $error; ?></p>
            <?php endif; ?>
            
            <form method="POST">
                <div class="form-group">
                    <label>Nama Produk</label>
                    <input type="text" name="name" value="<?php echo htmlspecialchars($name); ?>" required>
                </div>
                
                <div class="form-group">
                    <label>Kategori</label>
                    <input type="text" name="category" value="<?php echo htmlspecialchars($category); ?>" placeholder="Contoh: makanan, minuman" required>
                </div>

                <div class="form-group">
                    <label>Harga (Rp)</label>
                    <input type="number" name="price" value="<?php echo $price; ?>" step="0.01" required>
                </div>

                <div class="form-group">
                    <label>Status</label>
                    <select name="is_active">
                        <option value="1" <?php echo $is_active == 1 ? 'selected' : ''; ?>>Aktif</option>
                        <option value="0" <?php echo $is_active == 0 ? 'selected' : ''; ?>>Non-Aktif</option>
                    </select>
                </div>

                <div style="margin-top: 20px; display: flex; gap: 10px;">
                    <button type="submit" class="btn btn-primary">Simpan</button>
                    <a href="products.php" class="btn btn-secondary">Batal</a>
                </div>
            </form>
        </div>
    </div>

</body>
</html>