<?php
session_start();
if (!isset($_SESSION['admin_logged_in']) || $_SESSION['admin_logged_in'] !== true) {
    header("Location: login.php");
    exit;
}
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dashboard Admin</title>
    <style>
        body { margin: 0; font-family: sans-serif; display: flex; height: 100vh; background-color: #f0f2f5; }
        .sidebar { width: 250px; background-color: #343a40; color: white; display: flex; flex-direction: column; }
        .sidebar-header { padding: 20px; text-align: center; border-bottom: 1px solid #4b545c; font-size: 20px; font-weight: bold; }
        .menu { list-style: none; padding: 0; margin: 0; }
        .menu li { border-bottom: 1px solid #4b545c; }
        .menu a { display: block; padding: 15px 20px; color: #c2c7d0; text-decoration: none; transition: 0.3s; }
        .menu a:hover, .menu a.active { background-color: #495057; color: white; }
        .content { flex: 1; padding: 20px; overflow-y: auto; }
        .header { background: white; padding: 15px; border-radius: 5px; box-shadow: 0 2px 5px rgba(0,0,0,0.1); display: flex; justify-content: space-between; align-items: center; margin-bottom: 20px; }
        .card { background: white; padding: 20px; border-radius: 5px; box-shadow: 0 2px 5px rgba(0,0,0,0.1); margin-bottom: 20px; }
        .btn-logout { background-color: #dc3545; color: white; padding: 8px 15px; text-decoration: none; border-radius: 4px; font-size: 14px; }
        .btn-logout:hover { background-color: #c82333; }
        .info-box { display: flex; gap: 20px; }
        .box { flex: 1; background: #007bff; color: white; padding: 20px; border-radius: 5px; text-align: center; }
        .box h3 { margin: 0; font-size: 30px; }
        .box p { margin: 5px 0 0; }
    </style>
</head>
<body>

    <div class="sidebar">
        <div class="sidebar-header">Admin Panel</div>
        <ul class="menu">
            <li><a href="index.php" class="active">Dashboard</a></li>
            <li><a href="branches.php">Outlet</a></li>
            <li><a href="users.php">Karyawan</a></li>
            <li><a href="products.php">Produk</a></li>
            <li><a href="stocks.php">Stok</a></li>
            <li><a href="transactions.php">Laporan</a></li>
        </ul>
    </div>

    <div class="content">
        <div class="header">
            <h2>Dashboard</h2>
            <a href="logout.php" class="btn-logout">Keluar</a>
        </div>
        
        <div class="card">
            <h3>Selamat Datang, <?php echo htmlspecialchars($_SESSION['admin_name']); ?></h3>
            <p>Silakan pilih menu di sebelah kiri untuk mengelola aplikasi kasir.</p>
        </div>

        <div class="info-box">
            <div class="box">
                <h3>Akses Cepat</h3>
                <p>Kelola data produk, cek stok, dan lihat laporan penjualan dengan mudah.</p>
            </div>
        </div>
    </div>

</body>
</html>